/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.visio.VWItemTypeListCellRenderer;
import filenet.vw.toolkit.design.visio.VWMappingTableModel;
import filenet.vw.toolkit.design.visio.VWWizardHelper;
import filenet.vw.toolkit.design.visio.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWLineBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;

class VWMappingSelectionPanel
extends JPanel
implements IVWWizardPanel,
ActionListener {
    private VWWizardHelper m_wizardHelper = null;
    private JLabel m_fileNameLabel = null;
    private JButton m_browseButton = null;
    private JButton m_saveButton = null;
    private JButton m_resetButton = null;
    private JRadioButton m_unmappedRadioButton = null;
    private JRadioButton m_allShapesRadioButton = null;
    private VWTable m_mappingTable = null;
    private VWMappingTableModel m_mappingTableModel = null;

    public VWMappingSelectionPanel(VWWizardHelper wizardHelper) {
        this.m_wizardHelper = wizardHelper;
        this.createControls();
    }

    public void checkForErrors() throws Exception {
        if (this.m_mappingTableModel != null && this.m_mappingTableModel.isAllItemsMapped()) {
            int nReply;
            if (this.m_mappingTableModel.isAnyItemsModified() && (nReply = VWMessageDialog.showConfirmDialog(this.m_wizardHelper.getParentDialog(), VWResource.s_saveMappingChanges, VWResource.s_visioImportDialogTitle, 3)) == 1) {
                this.m_wizardHelper.saveAsNewMappingFile();
            }
            return;
        }
        throw new VWException("vw.toolkit.design.visio.invalidMapping", "Please map all Visio shapes to Process Designer objects. Visio shapes that are mapped to \"Nothing\" will not be imported.");
    }

    public String getHelpTopic() {
        return "mapping_selection";
    }

    public String getUniqueIdentifier() {
        return "MAPPING_SELECTION";
    }

    public String getInstructions() {
        return VWResource.s_mappingSelectionInstructions;
    }

    public String getTitle() {
        return VWResource.s_mappingSelectionTitle;
    }

    public void initialize() throws Exception {
        if (this.m_mappingTable != null) {
            this.m_mappingTable.stopEditing();
        }
        if (this.m_mappingTableModel != null && this.m_allShapesRadioButton != null) {
            this.m_mappingTableModel.reinitialize(this.m_allShapesRadioButton.isSelected());
        }
        this.m_fileNameLabel.setText(this.m_wizardHelper.getMappingFileName());
    }

    public void releaseResources() {
        if (this.m_unmappedRadioButton != null) {
            this.m_unmappedRadioButton.removeActionListener(this);
            this.m_unmappedRadioButton = null;
        }
        if (this.m_allShapesRadioButton != null) {
            this.m_allShapesRadioButton.removeActionListener(this);
            this.m_allShapesRadioButton = null;
        }
        this.m_mappingTable = null;
        this.m_mappingTableModel = null;
        this.removeAll();
    }

    public boolean getDisplayState() {
        return true;
    }

    public void setDisplayState(boolean bState) {
    }

    public boolean getEnableFinishButton() {
        return false;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (this.m_mappingTable != null) {
                this.m_mappingTable.stopEditing();
            }
            if (event.getSource().equals(this.m_browseButton)) {
                this.m_wizardHelper.openLocalMappingFile();
                this.initialize();
            } else if (event.getSource().equals(this.m_saveButton)) {
                this.m_wizardHelper.saveAsNewMappingFile();
                this.initialize();
            } else if (event.getSource().equals(this.m_resetButton)) {
                this.m_wizardHelper.loadDefaultMappingFile();
                this.initialize();
            } else if (event.getSource().equals(this.m_unmappedRadioButton)) {
                this.initialize();
            } else if (event.getSource().equals(this.m_allShapesRadioButton)) {
                this.initialize();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_wizardHelper.getParentDialog(), ex.getLocalizedMessage(), VWResource.s_fileOpenErrorTitle, 1);
        }
    }

    private void createControls() {
        try {
            this.setLayout(new BorderLayout(15, 15));
            JPanel childPanel = this.getFileControls();
            this.add((Component)childPanel, "First");
            JPanel mainPanel = this.createMainControls();
            this.add((Component)mainPanel, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getFileControls() {
        try {
            JPanel childPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            childPanel.add((Component)new JLabel(VWResource.s_mappingFile), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.insets = new Insets(0, 3, 0, 0);
            this.m_fileNameLabel = new JLabel();
            this.m_fileNameLabel.setName("m_fileNameLabel_VWMappingSelectionPanel");
            childPanel.add((Component)this.m_fileNameLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_browseButton = new JButton(VWResource.s_browseDots);
            this.m_browseButton.setName("m_browseButton_VWMappingSelectionPanel");
            this.m_browseButton.addActionListener(this);
            childPanel.add((Component)this.m_browseButton, gbCons);
            ++gbCons.gridx;
            this.m_saveButton = new JButton(VWResource.s_ellipse.toString(VWResource.s_save));
            this.m_saveButton.setName("m_saveButton_VWMappingSelectionPanel");
            this.m_saveButton.addActionListener(this);
            childPanel.add((Component)this.m_saveButton, gbCons);
            ++gbCons.gridx;
            this.m_resetButton = new JButton(VWResource.s_reset);
            this.m_resetButton.setName("m_resetButton_VWMappingSelectionPanel");
            this.m_resetButton.addActionListener(this);
            childPanel.add((Component)this.m_resetButton, gbCons);
            return childPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createMainControls() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.setBorder(new VWLineBorder());
            ButtonGroup buttonGroup = new ButtonGroup();
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.weightx = 0.5;
            this.m_unmappedRadioButton = new JRadioButton(VWResource.s_displayUnmappedShapes);
            this.m_unmappedRadioButton.setName("m_unmappedRadioButton_VWMappingSelectionPanel");
            this.m_unmappedRadioButton.setSelected(true);
            this.m_unmappedRadioButton.addActionListener(this);
            buttonGroup.add(this.m_unmappedRadioButton);
            mainPanel.add((Component)this.m_unmappedRadioButton, gbCons);
            ++gbCons.gridx;
            this.m_allShapesRadioButton = new JRadioButton(VWResource.s_displayAllShapes);
            this.m_allShapesRadioButton.setName("m_allShapesRadioButton_VWMappingSelectionPanel");
            this.m_allShapesRadioButton.addActionListener(this);
            buttonGroup.add(this.m_allShapesRadioButton);
            mainPanel.add((Component)this.m_allShapesRadioButton, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(0, 5, 0, 0);
            this.m_mappingTableModel = new VWMappingTableModel(this.m_wizardHelper);
            this.m_mappingTable = new VWTable(this.m_mappingTableModel);
            this.m_mappingTable.setName("m_mappingTable_VWMappingSelectionPanel");
            mainPanel.add((Component)new JScrollPane(this.m_mappingTable), gbCons);
            TableColumn tcElement = this.m_mappingTable.getColumnModel().getColumn(0);
            if (tcElement != null) {
                tcElement.setMaxWidth(20);
                tcElement.setMinWidth(20);
            }
            if ((tcElement = this.m_mappingTable.getColumnModel().getColumn(3)) != null) {
                VWItemTypeListCellRenderer tableCellRenderer = new VWItemTypeListCellRenderer(this.m_wizardHelper.getMappingLists());
                JComboBox comboBox = tableCellRenderer.getDesignerObjectComboBox();
                comboBox.setRenderer(tableCellRenderer);
                tcElement.setCellEditor(new DefaultCellEditor(comboBox));
                tcElement.setCellRenderer(tableCellRenderer);
            }
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

